/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management.access.constraint.sensitivity_classification.type;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.management.access.constraint.type.classification.AppliesTo;
import org.wildfly.swarm.config.management.access.constraint.type.classification.AppliesToConsumer;
import org.wildfly.swarm.config.management.access.constraint.type.classification.AppliesToSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/core-service=management/access=authorization/constraint=sensitivity-classification/type=*/classification=*")
@ResourceType(value="classification")
public class Classification<T extends Classification<T>> {
    private String key;
    private PropertyChangeSupport pcs;
    private ClassificationResources subresources = new ClassificationResources();
    private Boolean configuredRequiresAddressable;
    private Boolean configuredRequiresRead;
    private Boolean configuredRequiresWrite;
    private Boolean defaultRequiresAddressable;
    private Boolean defaultRequiresRead;
    private Boolean defaultRequiresWrite;

    public Classification(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ClassificationResources subresources() {
        return this.subresources;
    }

    public T appliesTos(List<AppliesTo> value) {
        this.subresources.appliesTos = value;
        return (T)this;
    }

    public T appliesTo(AppliesTo value) {
        this.subresources.appliesTos.add(value);
        return (T)this;
    }

    public T appliesTo(String childKey, AppliesToConsumer consumer) {
        AppliesTo child = new AppliesTo(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.appliesTo(child);
        return (T)this;
    }

    public T appliesTo(String childKey) {
        this.appliesTo(childKey, null);
        return (T)this;
    }

    public T appliesTo(AppliesToSupplier supplier) {
        this.appliesTo(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="configured-requires-addressable")
    public Boolean configuredRequiresAddressable() {
        return this.configuredRequiresAddressable;
    }

    public T configuredRequiresAddressable(Boolean value) {
        Boolean oldValue = this.configuredRequiresAddressable;
        this.configuredRequiresAddressable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("configuredRequiresAddressable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="configured-requires-read")
    public Boolean configuredRequiresRead() {
        return this.configuredRequiresRead;
    }

    public T configuredRequiresRead(Boolean value) {
        Boolean oldValue = this.configuredRequiresRead;
        this.configuredRequiresRead = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("configuredRequiresRead", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="configured-requires-write")
    public Boolean configuredRequiresWrite() {
        return this.configuredRequiresWrite;
    }

    public T configuredRequiresWrite(Boolean value) {
        Boolean oldValue = this.configuredRequiresWrite;
        this.configuredRequiresWrite = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("configuredRequiresWrite", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-requires-addressable")
    public Boolean defaultRequiresAddressable() {
        return this.defaultRequiresAddressable;
    }

    public T defaultRequiresAddressable(Boolean value) {
        Boolean oldValue = this.defaultRequiresAddressable;
        this.defaultRequiresAddressable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultRequiresAddressable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-requires-read")
    public Boolean defaultRequiresRead() {
        return this.defaultRequiresRead;
    }

    public T defaultRequiresRead(Boolean value) {
        Boolean oldValue = this.defaultRequiresRead;
        this.defaultRequiresRead = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultRequiresRead", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-requires-write")
    public Boolean defaultRequiresWrite() {
        return this.defaultRequiresWrite;
    }

    public T defaultRequiresWrite(Boolean value) {
        Boolean oldValue = this.defaultRequiresWrite;
        this.defaultRequiresWrite = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultRequiresWrite", oldValue, value);
        }
        return (T)this;
    }

    public static class ClassificationResources {
        private List<AppliesTo> appliesTos = new ArrayList<AppliesTo>();

        @Subresource
        public List<AppliesTo> appliesTos() {
            return this.appliesTos;
        }

        public AppliesTo appliesTo(String key) {
            return this.appliesTos.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

