/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management.security_realm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.management.Property;
import org.wildfly.swarm.config.management.PropertyConsumer;
import org.wildfly.swarm.config.management.PropertySupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/core-service=management/security-realm=*/authentication=plug-in")
@ResourceType(value="authentication")
@Implicit
public class PlugInAuthentication<T extends PlugInAuthentication<T>> {
    private String key = "plug-in";
    private PropertyChangeSupport pcs;
    private PlugInAuthenticationResources subresources = new PlugInAuthenticationResources();
    private Mechanism mechanism;
    private String name;

    public PlugInAuthentication() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public PlugInAuthenticationResources subresources() {
        return this.subresources;
    }

    public T properties(List<Property> value) {
        this.subresources.properties = value;
        return (T)this;
    }

    public T property(Property value) {
        this.subresources.properties.add(value);
        return (T)this;
    }

    public T property(String childKey, PropertyConsumer consumer) {
        Property child = new Property(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.property(child);
        return (T)this;
    }

    public T property(String childKey) {
        this.property(childKey, null);
        return (T)this;
    }

    public T property(PropertySupplier supplier) {
        this.property(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="mechanism")
    public Mechanism mechanism() {
        return this.mechanism;
    }

    public T mechanism(Mechanism value) {
        Mechanism oldValue = this.mechanism;
        this.mechanism = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("mechanism", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="name")
    public String name() {
        return this.name;
    }

    public T name(String value) {
        String oldValue = this.name;
        this.name = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("name", oldValue, value);
        }
        return (T)this;
    }

    public static enum Mechanism {
        DIGEST("DIGEST"),
        PLAIN("PLAIN");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private Mechanism(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static class PlugInAuthenticationResources {
        private List<Property> properties = new ArrayList<Property>();

        @Subresource
        public List<Property> properties() {
            return this.properties;
        }

        public Property property(String key) {
            return this.properties.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

