/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.node.Context;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.node.ContextConsumer;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.node.ContextSupplier;

@Address(value="/subsystem=undertow/configuration=filter/mod-cluster=*/balancer=*/node=*")
@ResourceType(value="node")
public class Node<T extends Node<T>> {
    private String key;
    private PropertyChangeSupport pcs;
    private NodeResources subresources = new NodeResources();
    private List<String> aliases;
    private Integer cacheConnections;
    private Integer elected;
    private Boolean flushPackets;
    private Integer load;
    private String loadBalancingGroup;
    private Integer maxConnections;
    private Integer openConnections;
    private Integer ping;
    private Boolean queueNewRequests;
    private Long read;
    private Integer requestQueueSize;
    private String status;
    private Integer timeout;
    private Long ttl;
    private String uri;
    private Long written;

    public Node(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public NodeResources subresources() {
        return this.subresources;
    }

    public T contexts(List<Context> value) {
        this.subresources.contexts = value;
        return (T)this;
    }

    public T context(Context value) {
        this.subresources.contexts.add(value);
        return (T)this;
    }

    public T context(String childKey, ContextConsumer consumer) {
        Context child = new Context(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.context(child);
        return (T)this;
    }

    public T context(String childKey) {
        this.context(childKey, null);
        return (T)this;
    }

    public T context(ContextSupplier supplier) {
        this.context(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="aliases")
    public List<String> aliases() {
        return this.aliases;
    }

    public T aliases(List<String> value) {
        List<String> oldValue = this.aliases;
        this.aliases = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("aliases", oldValue, value);
        }
        return (T)this;
    }

    public T alias(String value) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<String>();
        }
        this.aliases.add(value);
        return (T)this;
    }

    public T aliases(String ... args) {
        this.aliases(Arrays.asList(args));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cache-connections")
    public Integer cacheConnections() {
        return this.cacheConnections;
    }

    public T cacheConnections(Integer value) {
        Integer oldValue = this.cacheConnections;
        this.cacheConnections = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cacheConnections", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="elected")
    public Integer elected() {
        return this.elected;
    }

    public T elected(Integer value) {
        Integer oldValue = this.elected;
        this.elected = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("elected", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="flush-packets")
    public Boolean flushPackets() {
        return this.flushPackets;
    }

    public T flushPackets(Boolean value) {
        Boolean oldValue = this.flushPackets;
        this.flushPackets = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("flushPackets", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="load")
    public Integer load() {
        return this.load;
    }

    public T load(Integer value) {
        Integer oldValue = this.load;
        this.load = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("load", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="load-balancing-group")
    public String loadBalancingGroup() {
        return this.loadBalancingGroup;
    }

    public T loadBalancingGroup(String value) {
        String oldValue = this.loadBalancingGroup;
        this.loadBalancingGroup = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("loadBalancingGroup", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-connections")
    public Integer maxConnections() {
        return this.maxConnections;
    }

    public T maxConnections(Integer value) {
        Integer oldValue = this.maxConnections;
        this.maxConnections = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxConnections", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="open-connections")
    public Integer openConnections() {
        return this.openConnections;
    }

    public T openConnections(Integer value) {
        Integer oldValue = this.openConnections;
        this.openConnections = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("openConnections", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ping")
    public Integer ping() {
        return this.ping;
    }

    public T ping(Integer value) {
        Integer oldValue = this.ping;
        this.ping = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("ping", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="queue-new-requests")
    public Boolean queueNewRequests() {
        return this.queueNewRequests;
    }

    public T queueNewRequests(Boolean value) {
        Boolean oldValue = this.queueNewRequests;
        this.queueNewRequests = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("queueNewRequests", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="read")
    public Long read() {
        return this.read;
    }

    public T read(Long value) {
        Long oldValue = this.read;
        this.read = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("read", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="request-queue-size")
    public Integer requestQueueSize() {
        return this.requestQueueSize;
    }

    public T requestQueueSize(Integer value) {
        Integer oldValue = this.requestQueueSize;
        this.requestQueueSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("requestQueueSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="status")
    public String status() {
        return this.status;
    }

    public T status(String value) {
        String oldValue = this.status;
        this.status = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("status", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="timeout")
    public Integer timeout() {
        return this.timeout;
    }

    public T timeout(Integer value) {
        Integer oldValue = this.timeout;
        this.timeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("timeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ttl")
    public Long ttl() {
        return this.ttl;
    }

    public T ttl(Long value) {
        Long oldValue = this.ttl;
        this.ttl = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("ttl", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="uri")
    public String uri() {
        return this.uri;
    }

    public T uri(String value) {
        String oldValue = this.uri;
        this.uri = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("uri", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="written")
    public Long written() {
        return this.written;
    }

    public T written(Long value) {
        Long oldValue = this.written;
        this.written = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("written", oldValue, value);
        }
        return (T)this;
    }

    public static class NodeResources {
        private List<Context> contexts = new ArrayList<Context>();

        @Subresource
        public List<Context> contexts() {
            return this.contexts;
        }

        public Context context(String key) {
            return this.contexts.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

