package org.wildfly.swarm.config.batch.jberet;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A thread factory (implementing java.util.concurrent.ThreadFactory).
 */
@Address("/subsystem=batch-jberet/thread-factory=*")
@ResourceType("thread-factory")
public class ThreadFactory<T extends ThreadFactory<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private String groupName;
	private String name;
	private Integer priority;
	private String threadNamePattern;

	public ThreadFactory(String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Specifies the name of a thread group to create for this thread factory.
	 */
	@ModelNodeBinding(detypedName = "group-name")
	public String groupName() {
		return this.groupName;
	}

	/**
	 * Specifies the name of a thread group to create for this thread factory.
	 */
	@SuppressWarnings("unchecked")
	public T groupName(String value) {
		Object oldValue = this.groupName;
		this.groupName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("groupName", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the created thread factory.
	 */
	@ModelNodeBinding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * The name of the created thread factory.
	 */
	@SuppressWarnings("unchecked")
	public T name(String value) {
		Object oldValue = this.name;
		this.name = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("name", oldValue, value);
		return (T) this;
	}

	/**
	 * May be used to specify the thread priority of created threads.
	 */
	@ModelNodeBinding(detypedName = "priority")
	public Integer priority() {
		return this.priority;
	}

	/**
	 * May be used to specify the thread priority of created threads.
	 */
	@SuppressWarnings("unchecked")
	public T priority(Integer value) {
		Object oldValue = this.priority;
		this.priority = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("priority", oldValue, value);
		return (T) this;
	}

	/**
	 * The template used to create names for threads. The following patterns may
	 * be used: %% - emit a percent sign %t - emit the per-factory thread
	 * sequence number %g - emit the global thread sequence number %f - emit the
	 * factory sequence number %i - emit the thread ID.
	 */
	@ModelNodeBinding(detypedName = "thread-name-pattern")
	public String threadNamePattern() {
		return this.threadNamePattern;
	}

	/**
	 * The template used to create names for threads. The following patterns may
	 * be used: %% - emit a percent sign %t - emit the per-factory thread
	 * sequence number %g - emit the global thread sequence number %f - emit the
	 * factory sequence number %i - emit the thread ID.
	 */
	@SuppressWarnings("unchecked")
	public T threadNamePattern(String value) {
		Object oldValue = this.threadNamePattern;
		this.threadNamePattern = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("threadNamePattern", oldValue, value);
		return (T) this;
	}
}