package org.wildfly.swarm.config.ee;

import org.wildfly.swarm.config.ee.ContextService;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ContextServiceConsumer<T extends ContextService<T>> {

	/**
	 * Configure a pre-constructed instance of ContextService resource
	 * 
	 * @parameter Instance of ContextService to configure
	 * @return nothing
	 */
	void accept(T value);

	default ContextServiceConsumer<T> andThen(ContextServiceConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}