package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Delivery group to manage delivery for mdbs
 */
@Address("/subsystem=ejb3/mdb-delivery-group=*")
@ResourceType("mdb-delivery-group")
public class MDBDeliveryGroup<T extends MDBDeliveryGroup<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private Boolean active;

	public MDBDeliveryGroup(String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Indicates if delivery for all MDBs belonging to this group is active
	 */
	@ModelNodeBinding(detypedName = "active")
	public Boolean active() {
		return this.active;
	}

	/**
	 * Indicates if delivery for all MDBs belonging to this group is active
	 */
	@SuppressWarnings("unchecked")
	public T active(Boolean value) {
		Object oldValue = this.active;
		this.active = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("active", oldValue, value);
		return (T) this;
	}
}