package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.StringJDBCStore;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface StringJDBCStoreConsumer<T extends StringJDBCStore<T>> {

	/**
	 * Configure a pre-constructed instance of StringJDBCStore resource
	 * 
	 * @parameter Instance of StringJDBCStore to configure
	 * @return nothing
	 */
	void accept(T value);

	default StringJDBCStoreConsumer<T> andThen(StringJDBCStoreConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}