package org.wildfly.swarm.config.jgroups;

import org.wildfly.swarm.config.jgroups.Stack;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface StackConsumer<T extends Stack<T>> {

	/**
	 * Configure a pre-constructed instance of Stack resource
	 * 
	 * @parameter Instance of Stack to configure
	 * @return nothing
	 */
	void accept(T value);

	default StackConsumer<T> andThen(StackConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}