package org.wildfly.swarm.config.mail.mail_session;

import org.wildfly.swarm.config.mail.mail_session.IMAPServer;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface IMAPServerConsumer<T extends IMAPServer<T>> {

	/**
	 * Configure a pre-constructed instance of IMAPServer resource
	 * 
	 * @parameter Instance of IMAPServer to configure
	 * @return nothing
	 */
	void accept(T value);

	default IMAPServerConsumer<T> andThen(IMAPServerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}