package org.wildfly.swarm.config.management;

import org.wildfly.swarm.config.management.NativeRemotingInterfaceManagementInterface;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface NativeRemotingInterfaceManagementInterfaceConsumer<T extends NativeRemotingInterfaceManagementInterface<T>> {

	/**
	 * Configure a pre-constructed instance of
	 * NativeRemotingInterfaceManagementInterface resource
	 * 
	 * @parameter Instance of NativeRemotingInterfaceManagementInterface to
	 *            configure
	 * @return nothing
	 */
	void accept(T value);

	default NativeRemotingInterfaceManagementInterfaceConsumer<T> andThen(
			NativeRemotingInterfaceManagementInterfaceConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}