package org.wildfly.swarm.config.management;

import org.wildfly.swarm.config.runtime.Addresses;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A property within a security realm resource.
 */
@Addresses({
		"/core-service=management/security-realm=*/authorization=plug-in/property=*",
		"/core-service=management/security-realm=*/authentication=plug-in/property=*",
		"/core-service=management/ldap-connection=*/property=*"})
@ResourceType("property")
public class Property<T extends Property<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private String value;

	public Property(String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The optional value of the property.
	 */
	@ModelNodeBinding(detypedName = "value")
	public String value() {
		return this.value;
	}

	/**
	 * The optional value of the property.
	 */
	@SuppressWarnings("unchecked")
	public T value(String value) {
		Object oldValue = this.value;
		this.value = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("value", oldValue, value);
		return (T) this;
	}
}