package org.wildfly.swarm.config.management.access;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A in-memory handler for use with the management audit logging service.
 */
@Address("/core-service=management/access=audit/in-memory-handler=*")
@ResourceType("in-memory-handler")
public class InMemoryHandler<T extends InMemoryHandler<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private Integer maxHistory;

	public InMemoryHandler(String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The maximum number of operation stored in history for this handler.
	 */
	@ModelNodeBinding(detypedName = "max-history")
	public Integer maxHistory() {
		return this.maxHistory;
	}

	/**
	 * The maximum number of operation stored in history for this handler.
	 */
	@SuppressWarnings("unchecked")
	public T maxHistory(Integer value) {
		Object oldValue = this.maxHistory;
		this.maxHistory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxHistory", oldValue, value);
		return (T) this;
	}
}