package org.wildfly.swarm.config.management.access.syslog_handler;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Configuration to append to syslog over tcp/ip.
 */
@Address("/core-service=management/access=audit/syslog-handler=*/protocol=tcp")
@ResourceType("protocol")
@Implicit
public class TcpProtocol<T extends TcpProtocol<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private String host;
	private String messageTransfer;
	private Integer port;
	private Integer reconnectTimeout;

	public TcpProtocol() {
		super();
		this.key = "tcp";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The host of the syslog server for the tcp requests.
	 */
	@ModelNodeBinding(detypedName = "host")
	public String host() {
		return this.host;
	}

	/**
	 * The host of the syslog server for the tcp requests.
	 */
	@SuppressWarnings("unchecked")
	public T host(String value) {
		Object oldValue = this.host;
		this.host = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("host", oldValue, value);
		return (T) this;
	}

	/**
	 * The message transfer setting as described in section 3.4 of RFC-6587.
	 * This can either be OCTET_COUNTING as described in section 3.4.1 of
	 * RFC-6587, or NON_TRANSPARENT_FRAMING as described in section 3.4.1 of
	 * RFC-6587. See your syslog provider's documentation for what is supported.
	 */
	@ModelNodeBinding(detypedName = "message-transfer")
	public String messageTransfer() {
		return this.messageTransfer;
	}

	/**
	 * The message transfer setting as described in section 3.4 of RFC-6587.
	 * This can either be OCTET_COUNTING as described in section 3.4.1 of
	 * RFC-6587, or NON_TRANSPARENT_FRAMING as described in section 3.4.1 of
	 * RFC-6587. See your syslog provider's documentation for what is supported.
	 */
	@SuppressWarnings("unchecked")
	public T messageTransfer(String value) {
		Object oldValue = this.messageTransfer;
		this.messageTransfer = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("messageTransfer", oldValue, value);
		return (T) this;
	}

	/**
	 * The port of the syslog server for the tcp requests.
	 */
	@ModelNodeBinding(detypedName = "port")
	public Integer port() {
		return this.port;
	}

	/**
	 * The port of the syslog server for the tcp requests.
	 */
	@SuppressWarnings("unchecked")
	public T port(Integer value) {
		Object oldValue = this.port;
		this.port = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("port", oldValue, value);
		return (T) this;
	}

	/**
	 * If a connection drop is detected, the number of seconds to wait before
	 * reconnecting. A negative number means don't reconnect automatically.
	 */
	@ModelNodeBinding(detypedName = "reconnect-timeout")
	public Integer reconnectTimeout() {
		return this.reconnectTimeout;
	}

	/**
	 * If a connection drop is detected, the number of seconds to wait before
	 * reconnecting. A negative number means don't reconnect automatically.
	 */
	@SuppressWarnings("unchecked")
	public T reconnectTimeout(Integer value) {
		Object oldValue = this.reconnectTimeout;
		this.reconnectTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("reconnectTimeout", oldValue, value);
		return (T) this;
	}
}