package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Configuration to use a JAAS LoginContext to authenticate the users.
 */
@Address("/core-service=management/security-realm=*/authentication=jaas")
@ResourceType("authentication")
@Implicit
public class JaasAuthentication<T extends JaasAuthentication<T>>
		extends
			HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private Boolean assignGroups;
	private String name;

	public JaasAuthentication() {
		super();
		this.key = "jaas";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Map the roles loaded by JAAS to groups.
	 */
	@ModelNodeBinding(detypedName = "assign-groups")
	public Boolean assignGroups() {
		return this.assignGroups;
	}

	/**
	 * Map the roles loaded by JAAS to groups.
	 */
	@SuppressWarnings("unchecked")
	public T assignGroups(Boolean value) {
		Object oldValue = this.assignGroups;
		this.assignGroups = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("assignGroups", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the JAAS configuration to use.
	 */
	@ModelNodeBinding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * The name of the JAAS configuration to use.
	 */
	@SuppressWarnings("unchecked")
	public T name(String value) {
		Object oldValue = this.name;
		this.name = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("name", oldValue, value);
		return (T) this;
	}
}