package org.wildfly.swarm.config.management.security_realm.server_identity;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
/**
 * Configuration of a keytab to use to represent a server or host controllers
 * identity.
 */
@Address("/core-service=management/security-realm=*/server-identity=kerberos/keytab=*")
@ResourceType("keytab")
public class Keytab<T extends Keytab<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private Boolean debug;
	private List<String> forHosts;
	private String path;
	private String relativeTo;

	public Keytab(String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Should additional debug logging be enabled during TGT acquisition?
	 */
	@ModelNodeBinding(detypedName = "debug")
	public Boolean debug() {
		return this.debug;
	}

	/**
	 * Should additional debug logging be enabled during TGT acquisition?
	 */
	@SuppressWarnings("unchecked")
	public T debug(Boolean value) {
		Object oldValue = this.debug;
		this.debug = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("debug", oldValue, value);
		return (T) this;
	}

	/**
	 * A server can be accessed using different host names, this attribute
	 * specifies which host names this keytab can be used with.
	 */
	@ModelNodeBinding(detypedName = "for-hosts")
	public List<String> forHosts() {
		return this.forHosts;
	}

	/**
	 * A server can be accessed using different host names, this attribute
	 * specifies which host names this keytab can be used with.
	 */
	@SuppressWarnings("unchecked")
	public T forHosts(List<String> value) {
		Object oldValue = this.forHosts;
		this.forHosts = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("forHosts", oldValue, value);
		return (T) this;
	}

	/**
	 * A server can be accessed using different host names, this attribute
	 * specifies which host names this keytab can be used with.
	 */
	@SuppressWarnings("unchecked")
	public T forHost(String value) {
		if (this.forHosts == null) {
			this.forHosts = new java.util.ArrayList<>();
		}
		this.forHosts.add(value);
		return (T) this;
	}

	/**
	 * A server can be accessed using different host names, this attribute
	 * specifies which host names this keytab can be used with.
	 */
	@SuppressWarnings("unchecked")
	public T forHosts(String... args) {
		forHosts(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * The path to the keytab.
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * The path to the keytab.
	 */
	@SuppressWarnings("unchecked")
	public T path(String value) {
		Object oldValue = this.path;
		this.path = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("path", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of another previously named path, or of one of the standard
	 * paths provided by the system. If 'relative-to' is provided, the value of
	 * the 'path' attribute is treated as relative to the path specified by this
	 * attribute.
	 */
	@ModelNodeBinding(detypedName = "relative-to")
	public String relativeTo() {
		return this.relativeTo;
	}

	/**
	 * The name of another previously named path, or of one of the standard
	 * paths provided by the system. If 'relative-to' is provided, the value of
	 * the 'path' attribute is treated as relative to the path specified by this
	 * attribute.
	 */
	@SuppressWarnings("unchecked")
	public T relativeTo(String value) {
		Object oldValue = this.relativeTo;
		this.relativeTo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("relativeTo", oldValue, value);
		return (T) this;
	}
}