package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.SecuritySetting;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface SecuritySettingConsumer<T extends SecuritySetting<T>> {

	/**
	 * Configure a pre-constructed instance of SecuritySetting resource
	 * 
	 * @parameter Instance of SecuritySetting to configure
	 * @return nothing
	 */
	void accept(T value);

	default SecuritySettingConsumer<T> andThen(SecuritySettingConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}