package org.wildfly.swarm.config.security.manager;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Map;
import java.util.Arrays;
/**
 * The permissions that are to be granted to deployments
 */
@Address("/subsystem=security-manager/deployment-permissions=default")
@ResourceType("deployment-permissions")
@Implicit
public class DefaultDeploymentPermissions<T extends DefaultDeploymentPermissions<T>>
		extends
			HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private List<java.util.Map> maximumPermissions;
	private List<java.util.Map> minimumPermissions;

	public DefaultDeploymentPermissions() {
		super();
		this.key = "default";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The maximum set of permissions that can be granted to a deployment or
	 * jars.
	 */
	@ModelNodeBinding(detypedName = "maximum-permissions")
	public List<Map> maximumPermissions() {
		return this.maximumPermissions;
	}

	/**
	 * The maximum set of permissions that can be granted to a deployment or
	 * jars.
	 */
	@SuppressWarnings("unchecked")
	public T maximumPermissions(List<java.util.Map> value) {
		Object oldValue = this.maximumPermissions;
		this.maximumPermissions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maximumPermissions", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum set of permissions that can be granted to a deployment or
	 * jars.
	 */
	@SuppressWarnings("unchecked")
	public T maximumPermission(Map value) {
		if (this.maximumPermissions == null) {
			this.maximumPermissions = new java.util.ArrayList<>();
		}
		this.maximumPermissions.add(value);
		return (T) this;
	}

	/**
	 * The maximum set of permissions that can be granted to a deployment or
	 * jars.
	 */
	@SuppressWarnings("unchecked")
	public T maximumPermissions(Map... args) {
		maximumPermissions(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * The minimum set of permissions to be granted to a deployment or jars.
	 */
	@ModelNodeBinding(detypedName = "minimum-permissions")
	public List<Map> minimumPermissions() {
		return this.minimumPermissions;
	}

	/**
	 * The minimum set of permissions to be granted to a deployment or jars.
	 */
	@SuppressWarnings("unchecked")
	public T minimumPermissions(List<java.util.Map> value) {
		Object oldValue = this.minimumPermissions;
		this.minimumPermissions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("minimumPermissions", oldValue, value);
		return (T) this;
	}

	/**
	 * The minimum set of permissions to be granted to a deployment or jars.
	 */
	@SuppressWarnings("unchecked")
	public T minimumPermission(Map value) {
		if (this.minimumPermissions == null) {
			this.minimumPermissions = new java.util.ArrayList<>();
		}
		this.minimumPermissions.add(value);
		return (T) this;
	}

	/**
	 * The minimum set of permissions to be granted to a deployment or jars.
	 */
	@SuppressWarnings("unchecked")
	public T minimumPermissions(Map... args) {
		minimumPermissions(Arrays.asList(args));
		return (T) this;
	}
}