package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * JSSE configuration. Configures attributes for keystores that can be used for
 * setting up SSL.
 */
@Address("/subsystem=security/security-domain=*/jsse=classic")
@ResourceType("jsse")
@Implicit
public class ClassicJSSE<T extends ClassicJSSE<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private Map additionalProperties;
	private String cipherSuites;
	private String clientAlias;
	private Boolean clientAuth;
	private Map keyManager;
	private Map keystore;
	private String protocols;
	private String serverAlias;
	private String serviceAuthToken;
	private Map trustManager;
	private Map truststore;

	public ClassicJSSE() {
		super();
		this.key = "classic";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Additional properties that may be necessary to configure JSSE.
	 */
	@ModelNodeBinding(detypedName = "additional-properties")
	public Map additionalProperties() {
		return this.additionalProperties;
	}

	/**
	 * Additional properties that may be necessary to configure JSSE.
	 */
	@SuppressWarnings("unchecked")
	public T additionalProperties(Map value) {
		Object oldValue = this.additionalProperties;
		this.additionalProperties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("additionalProperties", oldValue, value);
		return (T) this;
	}

	/**
	 * Additional properties that may be necessary to configure JSSE.
	 */
	@SuppressWarnings("unchecked")
	public T additionalProperty(String key, Object value) {
		if (this.additionalProperties == null) {
			this.additionalProperties = new java.util.HashMap<>();
		}
		this.additionalProperties.put(key, value);
		return (T) this;
	}

	/**
	 * Comma separated list of cipher suites to enable on SSLSockets.
	 */
	@ModelNodeBinding(detypedName = "cipher-suites")
	public String cipherSuites() {
		return this.cipherSuites;
	}

	/**
	 * Comma separated list of cipher suites to enable on SSLSockets.
	 */
	@SuppressWarnings("unchecked")
	public T cipherSuites(String value) {
		Object oldValue = this.cipherSuites;
		this.cipherSuites = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cipherSuites", oldValue, value);
		return (T) this;
	}

	/**
	 * Preferred alias to use when the KeyManager chooses the client alias.
	 */
	@ModelNodeBinding(detypedName = "client-alias")
	public String clientAlias() {
		return this.clientAlias;
	}

	/**
	 * Preferred alias to use when the KeyManager chooses the client alias.
	 */
	@SuppressWarnings("unchecked")
	public T clientAlias(String value) {
		Object oldValue = this.clientAlias;
		this.clientAlias = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clientAlias", oldValue, value);
		return (T) this;
	}

	/**
	 * Boolean attribute to indicate if client's certificates should also be
	 * authenticated on the server side.
	 */
	@ModelNodeBinding(detypedName = "client-auth")
	public Boolean clientAuth() {
		return this.clientAuth;
	}

	/**
	 * Boolean attribute to indicate if client's certificates should also be
	 * authenticated on the server side.
	 */
	@SuppressWarnings("unchecked")
	public T clientAuth(Boolean value) {
		Object oldValue = this.clientAuth;
		this.clientAuth = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clientAuth", oldValue, value);
		return (T) this;
	}

	/**
	 * JSEE Key Manager factory
	 */
	@ModelNodeBinding(detypedName = "key-manager")
	public Map keyManager() {
		return this.keyManager;
	}

	/**
	 * JSEE Key Manager factory
	 */
	@SuppressWarnings("unchecked")
	public T keyManager(Map value) {
		Object oldValue = this.keyManager;
		this.keyManager = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keyManager", oldValue, value);
		return (T) this;
	}

	/**
	 * JSEE Key Manager factory
	 */
	@SuppressWarnings("unchecked")
	public T keyManager(String key, Object value) {
		if (this.keyManager == null) {
			this.keyManager = new java.util.HashMap<>();
		}
		this.keyManager.put(key, value);
		return (T) this;
	}

	/**
	 * Configures a JSSE key store
	 */
	@ModelNodeBinding(detypedName = "keystore")
	public Map keystore() {
		return this.keystore;
	}

	/**
	 * Configures a JSSE key store
	 */
	@SuppressWarnings("unchecked")
	public T keystore(Map value) {
		Object oldValue = this.keystore;
		this.keystore = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keystore", oldValue, value);
		return (T) this;
	}

	/**
	 * Configures a JSSE key store
	 */
	@SuppressWarnings("unchecked")
	public T keystore(String key, Object value) {
		if (this.keystore == null) {
			this.keystore = new java.util.HashMap<>();
		}
		this.keystore.put(key, value);
		return (T) this;
	}

	/**
	 * Comma separated list of protocols to enable on SSLSockets.
	 */
	@ModelNodeBinding(detypedName = "protocols")
	public String protocols() {
		return this.protocols;
	}

	/**
	 * Comma separated list of protocols to enable on SSLSockets.
	 */
	@SuppressWarnings("unchecked")
	public T protocols(String value) {
		Object oldValue = this.protocols;
		this.protocols = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("protocols", oldValue, value);
		return (T) this;
	}

	/**
	 * Preferred alias to use when the KeyManager chooses the server alias.
	 */
	@ModelNodeBinding(detypedName = "server-alias")
	public String serverAlias() {
		return this.serverAlias;
	}

	/**
	 * Preferred alias to use when the KeyManager chooses the server alias.
	 */
	@SuppressWarnings("unchecked")
	public T serverAlias(String value) {
		Object oldValue = this.serverAlias;
		this.serverAlias = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serverAlias", oldValue, value);
		return (T) this;
	}

	/**
	 * Token to retrieve PrivateKeys from the KeyStore.
	 */
	@ModelNodeBinding(detypedName = "service-auth-token")
	public String serviceAuthToken() {
		return this.serviceAuthToken;
	}

	/**
	 * Token to retrieve PrivateKeys from the KeyStore.
	 */
	@SuppressWarnings("unchecked")
	public T serviceAuthToken(String value) {
		Object oldValue = this.serviceAuthToken;
		this.serviceAuthToken = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serviceAuthToken", oldValue, value);
		return (T) this;
	}

	/**
	 * JSEE Trust Manager factory
	 */
	@ModelNodeBinding(detypedName = "trust-manager")
	public Map trustManager() {
		return this.trustManager;
	}

	/**
	 * JSEE Trust Manager factory
	 */
	@SuppressWarnings("unchecked")
	public T trustManager(Map value) {
		Object oldValue = this.trustManager;
		this.trustManager = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("trustManager", oldValue, value);
		return (T) this;
	}

	/**
	 * JSEE Trust Manager factory
	 */
	@SuppressWarnings("unchecked")
	public T trustManager(String key, Object value) {
		if (this.trustManager == null) {
			this.trustManager = new java.util.HashMap<>();
		}
		this.trustManager.put(key, value);
		return (T) this;
	}

	/**
	 * Configures a JSSE trust store
	 */
	@ModelNodeBinding(detypedName = "truststore")
	public Map truststore() {
		return this.truststore;
	}

	/**
	 * Configures a JSSE trust store
	 */
	@SuppressWarnings("unchecked")
	public T truststore(Map value) {
		Object oldValue = this.truststore;
		this.truststore = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("truststore", oldValue, value);
		return (T) this;
	}

	/**
	 * Configures a JSSE trust store
	 */
	@SuppressWarnings("unchecked")
	public T truststore(String key, Object value) {
		if (this.truststore == null) {
			this.truststore = new java.util.HashMap<>();
		}
		this.truststore.put(key, value);
		return (T) this;
	}
}