package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The error pages
 */
@Address("/subsystem=undertow/configuration=filter/error-page=*")
@ResourceType("error-page")
public class ErrorPage<T extends ErrorPage<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private Integer code;
	private String path;

	public ErrorPage(String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Error page code
	 */
	@ModelNodeBinding(detypedName = "code")
	public Integer code() {
		return this.code;
	}

	/**
	 * Error page code
	 */
	@SuppressWarnings("unchecked")
	public T code(Integer value) {
		Object oldValue = this.code;
		this.code = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("code", oldValue, value);
		return (T) this;
	}

	/**
	 * Error page path
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * Error page path
	 */
	@SuppressWarnings("unchecked")
	public T path(String value) {
		Object oldValue = this.path;
		this.path = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("path", oldValue, value);
		return (T) this;
	}
}