package org.wildfly.swarm.config.webservices;

import org.wildfly.swarm.config.webservices.ClientConfig;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ClientConfigConsumer<T extends ClientConfig<T>> {

	/**
	 * Configure a pre-constructed instance of ClientConfig resource
	 * 
	 * @parameter Instance of ClientConfig to configure
	 * @return nothing
	 */
	void accept(T value);

	default ClientConfigConsumer<T> andThen(ClientConfigConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}