/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.security.security_domain;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.acl.ACLModule;
import org.wildfly.swarm.config.security.security_domain.acl.ACLModuleConsumer;
import org.wildfly.swarm.config.security.security_domain.acl.ACLModuleSupplier;

@Address(value="/subsystem=security/security-domain=*/acl=classic")
@ResourceType(value="acl")
@Implicit
public class ClassicACL<T extends ClassicACL<T>>
extends HashMap {
    private String key = "classic";
    private PropertyChangeSupport pcs;
    private ClassicACLResources subresources = new ClassicACLResources();

    public ClassicACL() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ClassicACLResources subresources() {
        return this.subresources;
    }

    public T aclModules(List<ACLModule> value) {
        this.subresources.aclModules = value;
        return (T)this;
    }

    public T aclModule(ACLModule value) {
        this.subresources.aclModules.add(value);
        return (T)this;
    }

    public T aclModule(String childKey, ACLModuleConsumer consumer) {
        ACLModule child = new ACLModule(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.aclModule(child);
        return (T)this;
    }

    public T aclModule(String childKey) {
        this.aclModule(childKey, null);
        return (T)this;
    }

    public T aclModule(ACLModuleSupplier supplier) {
        this.aclModule(supplier.get());
        return (T)this;
    }

    public static class ClassicACLResources {
        private List<ACLModule> aclModules = new ArrayList<ACLModule>();

        @Subresource
        public List<ACLModule> aclModules() {
            return this.aclModules;
        }

        public ACLModule aclModule(String key) {
            return this.aclModules.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

