package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The JSF subsystem
 */
@Address("/subsystem=jsf")
@ResourceType("subsystem")
@Implicit
public class JSF<T extends JSF<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private String defaultJsfImplSlot;

	public JSF() {
		super();
		this.key = "jsf";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Default JSF implementation slot
	 */
	@ModelNodeBinding(detypedName = "default-jsf-impl-slot")
	public String defaultJsfImplSlot() {
		return this.defaultJsfImplSlot;
	}

	/**
	 * Default JSF implementation slot
	 */
	@SuppressWarnings("unchecked")
	public T defaultJsfImplSlot(String value) {
		Object oldValue = this.defaultJsfImplSlot;
		this.defaultJsfImplSlot = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultJsfImplSlot", oldValue, value);
		return (T) this;
	}
}