package org.wildfly.swarm.config.ee;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The JNDI names for the default EE bindings
 */
@Address("/subsystem=ee/service=default-bindings")
@ResourceType("service")
@Implicit
public class DefaultBindingsService<T extends DefaultBindingsService<T>>
		extends
			HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private String contextService;
	private String datasource;
	private String jmsConnectionFactory;
	private String managedExecutorService;
	private String managedScheduledExecutorService;
	private String managedThreadFactory;

	public DefaultBindingsService() {
		super();
		this.key = "default-bindings";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The JNDI name where the default EE Context Service can be found
	 */
	@ModelNodeBinding(detypedName = "context-service")
	public String contextService() {
		return this.contextService;
	}

	/**
	 * The JNDI name where the default EE Context Service can be found
	 */
	@SuppressWarnings("unchecked")
	public T contextService(String value) {
		Object oldValue = this.contextService;
		this.contextService = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("contextService", oldValue, value);
		return (T) this;
	}

	/**
	 * The JNDI name where the default EE Datasource can be found
	 */
	@ModelNodeBinding(detypedName = "datasource")
	public String datasource() {
		return this.datasource;
	}

	/**
	 * The JNDI name where the default EE Datasource can be found
	 */
	@SuppressWarnings("unchecked")
	public T datasource(String value) {
		Object oldValue = this.datasource;
		this.datasource = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("datasource", oldValue, value);
		return (T) this;
	}

	/**
	 * The JNDI name where the default EE JMS Connection Factory can be found
	 */
	@ModelNodeBinding(detypedName = "jms-connection-factory")
	public String jmsConnectionFactory() {
		return this.jmsConnectionFactory;
	}

	/**
	 * The JNDI name where the default EE JMS Connection Factory can be found
	 */
	@SuppressWarnings("unchecked")
	public T jmsConnectionFactory(String value) {
		Object oldValue = this.jmsConnectionFactory;
		this.jmsConnectionFactory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jmsConnectionFactory", oldValue, value);
		return (T) this;
	}

	/**
	 * The JNDI name where the default EE Managed Executor Service can be found
	 */
	@ModelNodeBinding(detypedName = "managed-executor-service")
	public String managedExecutorService() {
		return this.managedExecutorService;
	}

	/**
	 * The JNDI name where the default EE Managed Executor Service can be found
	 */
	@SuppressWarnings("unchecked")
	public T managedExecutorService(String value) {
		Object oldValue = this.managedExecutorService;
		this.managedExecutorService = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("managedExecutorService", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The JNDI name where the default EE Managed Scheduled Executor Service can
	 * be found
	 */
	@ModelNodeBinding(detypedName = "managed-scheduled-executor-service")
	public String managedScheduledExecutorService() {
		return this.managedScheduledExecutorService;
	}

	/**
	 * The JNDI name where the default EE Managed Scheduled Executor Service can
	 * be found
	 */
	@SuppressWarnings("unchecked")
	public T managedScheduledExecutorService(String value) {
		Object oldValue = this.managedScheduledExecutorService;
		this.managedScheduledExecutorService = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("managedScheduledExecutorService",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The JNDI name where the default EE Managed Thread Factory can be found
	 */
	@ModelNodeBinding(detypedName = "managed-thread-factory")
	public String managedThreadFactory() {
		return this.managedThreadFactory;
	}

	/**
	 * The JNDI name where the default EE Managed Thread Factory can be found
	 */
	@SuppressWarnings("unchecked")
	public T managedThreadFactory(String value) {
		Object oldValue = this.managedThreadFactory;
		this.managedThreadFactory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("managedThreadFactory", oldValue, value);
		return (T) this;
	}
}