package org.wildfly.swarm.config.ejb3.service;

import org.wildfly.swarm.config.ejb3.service.DatabaseDataStore;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface DatabaseDataStoreConsumer<T extends DatabaseDataStore<T>> {

	/**
	 * Configure a pre-constructed instance of DatabaseDataStore resource
	 * 
	 * @parameter Instance of DatabaseDataStore to configure
	 * @return nothing
	 */
	void accept(T value);

	default DatabaseDataStoreConsumer<T> andThen(
			DatabaseDataStoreConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}