package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.Backup;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface BackupConsumer<T extends Backup<T>> {

	/**
	 * Configure a pre-constructed instance of Backup resource
	 * 
	 * @parameter Instance of Backup to configure
	 * @return nothing
	 */
	void accept(T value);

	default BackupConsumer<T> andThen(BackupConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}