package org.wildfly.swarm.config.jca;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Bootstrap context for resource adapters
 */
@Address("/subsystem=jca/bootstrap-context=*")
@ResourceType("bootstrap-context")
public class BootstrapContext<T extends BootstrapContext<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private String name;
	private String workmanager;

	public BootstrapContext(String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The name of the BootstrapContext
	 */
	@ModelNodeBinding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * The name of the BootstrapContext
	 */
	@SuppressWarnings("unchecked")
	public T name(String value) {
		Object oldValue = this.name;
		this.name = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("name", oldValue, value);
		return (T) this;
	}

	/**
	 * The WorkManager instance for the BootstrapContext
	 */
	@ModelNodeBinding(detypedName = "workmanager")
	public String workmanager() {
		return this.workmanager;
	}

	/**
	 * The WorkManager instance for the BootstrapContext
	 */
	@SuppressWarnings("unchecked")
	public T workmanager(String value) {
		Object oldValue = this.workmanager;
		this.workmanager = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("workmanager", oldValue, value);
		return (T) this;
	}
}