package org.wildfly.swarm.config.jgroups.stack.relay;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A remote site to which to bridge.
 */
@Address("/subsystem=jgroups/stack=*/relay=relay.RELAY2/remote-site=*")
@ResourceType("remote-site")
public class RemoteSite<T extends RemoteSite<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private String channel;

	public RemoteSite(String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The name of the bridge channel used to communicate with this remote site.
	 */
	@ModelNodeBinding(detypedName = "channel")
	public String channel() {
		return this.channel;
	}

	/**
	 * The name of the bridge channel used to communicate with this remote site.
	 */
	@SuppressWarnings("unchecked")
	public T channel(String value) {
		Object oldValue = this.channel;
		this.channel = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("channel", oldValue, value);
		return (T) this;
	}
}