package org.wildfly.swarm.config.jgroups.stack.transport;

import org.wildfly.swarm.config.jgroups.stack.transport.InternalThreadPool;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface InternalThreadPoolConsumer<T extends InternalThreadPool<T>> {

	/**
	 * Configure a pre-constructed instance of InternalThreadPool resource
	 * 
	 * @parameter Instance of InternalThreadPool to configure
	 * @return nothing
	 */
	void accept(T value);

	default InternalThreadPoolConsumer<T> andThen(
			InternalThreadPoolConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}