package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.logging.LogFile;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface LogFileConsumer<T extends LogFile<T>> {

	/**
	 * Configure a pre-constructed instance of LogFile resource
	 * 
	 * @parameter Instance of LogFile to configure
	 * @return nothing
	 */
	void accept(T value);

	default LogFileConsumer<T> andThen(LogFileConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}