package org.wildfly.swarm.config.mail.mail_session;

import org.wildfly.swarm.config.mail.mail_session.POP3Server;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface POP3ServerConsumer<T extends POP3Server<T>> {

	/**
	 * Configure a pre-constructed instance of POP3Server resource
	 * 
	 * @parameter Instance of POP3Server to configure
	 * @return nothing
	 */
	void accept(T value);

	default POP3ServerConsumer<T> andThen(POP3ServerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}