package org.wildfly.swarm.config.management;

import org.wildfly.swarm.config.management.AuthorizationAccess;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface AuthorizationAccessConsumer<T extends AuthorizationAccess<T>> {

	/**
	 * Configure a pre-constructed instance of AuthorizationAccess resource
	 * 
	 * @parameter Instance of AuthorizationAccess to configure
	 * @return nothing
	 */
	void accept(T value);

	default AuthorizationAccessConsumer<T> andThen(
			AuthorizationAccessConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}