package org.wildfly.swarm.config.management;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.management.service.ActiveOperationConsumer;
import org.wildfly.swarm.config.management.service.ActiveOperationSupplier;
import org.wildfly.swarm.config.management.service.ActiveOperation;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Execution of management operations.
 */
@Address("/core-service=management/service=management-operations")
@ResourceType("service")
@Implicit
public class ManagementOperationsService<T extends ManagementOperationsService<T>>
		extends
			HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private ManagementOperationsServiceResources subresources = new ManagementOperationsServiceResources();

	public ManagementOperationsService() {
		super();
		this.key = "management-operations";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ManagementOperationsServiceResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all ActiveOperation objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ActiveOperation objects.
	 */
	@SuppressWarnings("unchecked")
	public T activeOperations(List<ActiveOperation> value) {
		this.subresources.activeOperations = value;
		return (T) this;
	}

	/**
	 * Add the ActiveOperation object to the list of subresources
	 * 
	 * @param value
	 *            The ActiveOperation to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T activeOperation(ActiveOperation value) {
		this.subresources.activeOperations.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ActiveOperation object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ActiveOperation resource
	 * @param config
	 *            The ActiveOperationConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T activeOperation(String childKey, ActiveOperationConsumer consumer) {
		ActiveOperation<? extends ActiveOperation> child = new ActiveOperation<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		activeOperation(child);
		return (T) this;
	}

	/**
	 * Create and configure a ActiveOperation object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ActiveOperation resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T activeOperation(String childKey) {
		activeOperation(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ActiveOperation object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T activeOperation(ActiveOperationSupplier supplier) {
		activeOperation(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for ManagementOperationsService
	 */
	public static class ManagementOperationsServiceResources {
		/**
		 * A currently executing operation.
		 */
		private List<ActiveOperation> activeOperations = new java.util.ArrayList<>();

		/**
		 * Get the list of ActiveOperation resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ActiveOperation> activeOperations() {
			return this.activeOperations;
		}

		public ActiveOperation activeOperation(String key) {
			return this.activeOperations.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}
}