package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.management.security_realm.SslServerIdentity;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface SslServerIdentityConsumer<T extends SslServerIdentity<T>> {

	/**
	 * Configure a pre-constructed instance of SslServerIdentity resource
	 * 
	 * @parameter Instance of SslServerIdentity to configure
	 * @return nothing
	 */
	void accept(T value);

	default SslServerIdentityConsumer<T> andThen(
			SslServerIdentityConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}