package org.wildfly.swarm.config.management.security_realm.authorization;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCache;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCacheConsumer;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCacheSupplier;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCache;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCacheConsumer;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCacheSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * User search configuration where the username is already a distinguished name.
 */
@Address("/core-service=management/security-realm=*/authorization=ldap/username-to-dn=username-is-dn")
@ResourceType("username-to-dn")
@Implicit
public class UsernameIsDnUsernameToDn<T extends UsernameIsDnUsernameToDn<T>>
		extends
			HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private UsernameIsDnUsernameToDnResources subresources = new UsernameIsDnUsernameToDnResources();
	private Boolean force;

	public UsernameIsDnUsernameToDn() {
		super();
		this.key = "username-is-dn";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public UsernameIsDnUsernameToDnResources subresources() {
		return this.subresources;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache(BySearchTimeCache value) {
		this.subresources.bySearchTimeCache = value;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache(BySearchTimeCacheConsumer consumer) {
		BySearchTimeCache<? extends BySearchTimeCache> child = new BySearchTimeCache<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.bySearchTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache() {
		BySearchTimeCache<? extends BySearchTimeCache> child = new BySearchTimeCache<>();
		this.subresources.bySearchTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache(BySearchTimeCacheSupplier supplier) {
		this.subresources.bySearchTimeCache = supplier.get();
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache(ByAccessTimeCache value) {
		this.subresources.byAccessTimeCache = value;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache(ByAccessTimeCacheConsumer consumer) {
		ByAccessTimeCache<? extends ByAccessTimeCache> child = new ByAccessTimeCache<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.byAccessTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache() {
		ByAccessTimeCache<? extends ByAccessTimeCache> child = new ByAccessTimeCache<>();
		this.subresources.byAccessTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache(ByAccessTimeCacheSupplier supplier) {
		this.subresources.byAccessTimeCache = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for UsernameIsDnUsernameToDn
	 */
	public static class UsernameIsDnUsernameToDnResources {
		private BySearchTimeCache bySearchTimeCache;
		private ByAccessTimeCache byAccessTimeCache;

		/**
		 * A cache to hold the results of previous LDAP interactions.
		 */
		@Subresource
		public BySearchTimeCache bySearchTimeCache() {
			return this.bySearchTimeCache;
		}

		/**
		 * A cache to hold the results of previous LDAP interactions.
		 */
		@Subresource
		public ByAccessTimeCache byAccessTimeCache() {
			return this.byAccessTimeCache;
		}
	}

	/**
	 * Authentication may have already converted the username to a distinguished
	 * name, force this to occur again before loading groups.
	 */
	@ModelNodeBinding(detypedName = "force")
	public Boolean force() {
		return this.force;
	}

	/**
	 * Authentication may have already converted the username to a distinguished
	 * name, force this to occur again before loading groups.
	 */
	@SuppressWarnings("unchecked")
	public T force(Boolean value) {
		Object oldValue = this.force;
		this.force = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("force", oldValue, value);
		return (T) this;
	}
}