package org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider;

import org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider.CustomLoadMetric;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface CustomLoadMetricConsumer<T extends CustomLoadMetric<T>> {

	/**
	 * Configure a pre-constructed instance of CustomLoadMetric resource
	 * 
	 * @parameter Instance of CustomLoadMetric to configure
	 * @return nothing
	 */
	void accept(T value);

	default CustomLoadMetricConsumer<T> andThen(
			CustomLoadMetricConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}