package org.wildfly.swarm.config.resource.adapters.resource_adapter;

import org.wildfly.swarm.config.resource.adapters.resource_adapter.AdminObjects;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface AdminObjectsConsumer<T extends AdminObjects<T>> {

	/**
	 * Configure a pre-constructed instance of AdminObjects resource
	 * 
	 * @parameter Instance of AdminObjects to configure
	 * @return nothing
	 */
	void accept(T value);

	default AdminObjectsConsumer<T> andThen(AdminObjectsConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}