package org.wildfly.swarm.config.undertow;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.server.HostConsumer;
import org.wildfly.swarm.config.undertow.server.HostSupplier;
import org.wildfly.swarm.config.undertow.server.Host;
import org.wildfly.swarm.config.undertow.server.HTTPListenerConsumer;
import org.wildfly.swarm.config.undertow.server.HTTPListenerSupplier;
import org.wildfly.swarm.config.undertow.server.HTTPListener;
import org.wildfly.swarm.config.undertow.server.AJPListenerConsumer;
import org.wildfly.swarm.config.undertow.server.AJPListenerSupplier;
import org.wildfly.swarm.config.undertow.server.AJPListener;
import org.wildfly.swarm.config.undertow.server.HttpsListenerConsumer;
import org.wildfly.swarm.config.undertow.server.HttpsListenerSupplier;
import org.wildfly.swarm.config.undertow.server.HttpsListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A server
 */
@Address("/subsystem=undertow/server=*")
@ResourceType("server")
public class Server<T extends Server<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private ServerResources subresources = new ServerResources();
	private String defaultHost;
	private String servletContainer;

	public Server(String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ServerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Host objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Host objects.
	 */
	@SuppressWarnings("unchecked")
	public T hosts(List<Host> value) {
		this.subresources.hosts = value;
		return (T) this;
	}

	/**
	 * Add the Host object to the list of subresources
	 * 
	 * @param value
	 *            The Host to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T host(Host value) {
		this.subresources.hosts.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Host object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Host resource
	 * @param config
	 *            The HostConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T host(String childKey, HostConsumer consumer) {
		Host<? extends Host> child = new Host<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		host(child);
		return (T) this;
	}

	/**
	 * Create and configure a Host object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Host resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T host(String childKey) {
		host(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Host object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T host(HostSupplier supplier) {
		host(supplier.get());
		return (T) this;
	}

	/**
	 * Add all HTTPListener objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of HTTPListener objects.
	 */
	@SuppressWarnings("unchecked")
	public T httpListeners(List<HTTPListener> value) {
		this.subresources.httpListeners = value;
		return (T) this;
	}

	/**
	 * Add the HTTPListener object to the list of subresources
	 * 
	 * @param value
	 *            The HTTPListener to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpListener(HTTPListener value) {
		this.subresources.httpListeners.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a HTTPListener object to the list of subresources
	 * 
	 * @param key
	 *            The key for the HTTPListener resource
	 * @param config
	 *            The HTTPListenerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpListener(String childKey, HTTPListenerConsumer consumer) {
		HTTPListener<? extends HTTPListener> child = new HTTPListener<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		httpListener(child);
		return (T) this;
	}

	/**
	 * Create and configure a HTTPListener object to the list of subresources
	 * 
	 * @param key
	 *            The key for the HTTPListener resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpListener(String childKey) {
		httpListener(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied HTTPListener object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T httpListener(HTTPListenerSupplier supplier) {
		httpListener(supplier.get());
		return (T) this;
	}

	/**
	 * Add all AJPListener objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of AJPListener objects.
	 */
	@SuppressWarnings("unchecked")
	public T ajpListeners(List<AJPListener> value) {
		this.subresources.ajpListeners = value;
		return (T) this;
	}

	/**
	 * Add the AJPListener object to the list of subresources
	 * 
	 * @param value
	 *            The AJPListener to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T ajpListener(AJPListener value) {
		this.subresources.ajpListeners.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a AJPListener object to the list of subresources
	 * 
	 * @param key
	 *            The key for the AJPListener resource
	 * @param config
	 *            The AJPListenerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T ajpListener(String childKey, AJPListenerConsumer consumer) {
		AJPListener<? extends AJPListener> child = new AJPListener<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		ajpListener(child);
		return (T) this;
	}

	/**
	 * Create and configure a AJPListener object to the list of subresources
	 * 
	 * @param key
	 *            The key for the AJPListener resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T ajpListener(String childKey) {
		ajpListener(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied AJPListener object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T ajpListener(AJPListenerSupplier supplier) {
		ajpListener(supplier.get());
		return (T) this;
	}

	/**
	 * Add all HttpsListener objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of HttpsListener objects.
	 */
	@SuppressWarnings("unchecked")
	public T httpsListeners(List<HttpsListener> value) {
		this.subresources.httpsListeners = value;
		return (T) this;
	}

	/**
	 * Add the HttpsListener object to the list of subresources
	 * 
	 * @param value
	 *            The HttpsListener to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpsListener(HttpsListener value) {
		this.subresources.httpsListeners.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a HttpsListener object to the list of subresources
	 * 
	 * @param key
	 *            The key for the HttpsListener resource
	 * @param config
	 *            The HttpsListenerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpsListener(String childKey, HttpsListenerConsumer consumer) {
		HttpsListener<? extends HttpsListener> child = new HttpsListener<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		httpsListener(child);
		return (T) this;
	}

	/**
	 * Create and configure a HttpsListener object to the list of subresources
	 * 
	 * @param key
	 *            The key for the HttpsListener resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpsListener(String childKey) {
		httpsListener(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied HttpsListener object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T httpsListener(HttpsListenerSupplier supplier) {
		httpsListener(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for Server
	 */
	public static class ServerResources {
		/**
		 * An Undertow host
		 */
		private List<Host> hosts = new java.util.ArrayList<>();
		/**
		 * http listener
		 */
		private List<HTTPListener> httpListeners = new java.util.ArrayList<>();
		/**
		 * http listener
		 */
		private List<AJPListener> ajpListeners = new java.util.ArrayList<>();
		/**
		 * http listener
		 */
		private List<HttpsListener> httpsListeners = new java.util.ArrayList<>();

		/**
		 * Get the list of Host resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Host> hosts() {
			return this.hosts;
		}

		public Host host(String key) {
			return this.hosts.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of HTTPListener resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<HTTPListener> httpListeners() {
			return this.httpListeners;
		}

		public HTTPListener httpListener(String key) {
			return this.httpListeners.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of AJPListener resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<AJPListener> ajpListeners() {
			return this.ajpListeners;
		}

		public AJPListener ajpListener(String key) {
			return this.ajpListeners.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of HttpsListener resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<HttpsListener> httpsListeners() {
			return this.httpsListeners;
		}

		public HttpsListener httpsListener(String key) {
			return this.httpsListeners.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}

	/**
	 * The servers default virtual host
	 */
	@ModelNodeBinding(detypedName = "default-host")
	public String defaultHost() {
		return this.defaultHost;
	}

	/**
	 * The servers default virtual host
	 */
	@SuppressWarnings("unchecked")
	public T defaultHost(String value) {
		Object oldValue = this.defaultHost;
		this.defaultHost = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultHost", oldValue, value);
		return (T) this;
	}

	/**
	 * The servers default servlet container
	 */
	@ModelNodeBinding(detypedName = "servlet-container")
	public String servletContainer() {
		return this.servletContainer;
	}

	/**
	 * The servers default servlet container
	 */
	@SuppressWarnings("unchecked")
	public T servletContainer(String value) {
		Object oldValue = this.servletContainer;
		this.servletContainer = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("servletContainer", oldValue, value);
		return (T) this;
	}
}