package org.wildfly.swarm.config.undertow.server;

import org.wildfly.swarm.config.undertow.server.AJPListener;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface AJPListenerConsumer<T extends AJPListener<T>> {

	/**
	 * Configure a pre-constructed instance of AJPListener resource
	 * 
	 * @parameter Instance of AJPListener to configure
	 * @return nothing
	 */
	void accept(T value);

	default AJPListenerConsumer<T> andThen(AJPListenerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}