package org.wildfly.swarm.config.webservices;

import org.wildfly.swarm.config.runtime.Addresses;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Endpoint handler
 */
@Addresses({
		"/subsystem=webservices/client-config=*/post-handler-chain=*/handler=*",
		"/subsystem=webservices/client-config=*/pre-handler-chain=*/handler=*",
		"/subsystem=webservices/endpoint-config=*/post-handler-chain=*/handler=*",
		"/subsystem=webservices/endpoint-config=*/pre-handler-chain=*/handler=*"})
@ResourceType("handler")
public class Handler<T extends Handler<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private String attributeClass;

	public Handler(String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Handler class
	 */
	@ModelNodeBinding(detypedName = "class")
	public String attributeClass() {
		return this.attributeClass;
	}

	/**
	 * Handler class
	 */
	@SuppressWarnings("unchecked")
	public T attributeClass(String value) {
		Object oldValue = this.attributeClass;
		this.attributeClass = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attributeClass", oldValue, value);
		return (T) this;
	}
}