/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.jca;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.jca.LongRunningThreads;
import org.wildfly.swarm.config.jca.LongRunningThreadsConsumer;
import org.wildfly.swarm.config.jca.LongRunningThreadsSupplier;
import org.wildfly.swarm.config.jca.ShortRunningThreads;
import org.wildfly.swarm.config.jca.ShortRunningThreadsConsumer;
import org.wildfly.swarm.config.jca.ShortRunningThreadsSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/subsystem=jca/workmanager=*")
@ResourceType(value="workmanager")
public class Workmanager<T extends Workmanager<T>>
extends HashMap {
    private String key;
    private PropertyChangeSupport pcs;
    private WorkmanagerResources subresources = new WorkmanagerResources();
    private String name;

    public Workmanager(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public WorkmanagerResources subresources() {
        return this.subresources;
    }

    public T longRunningThreads(List<LongRunningThreads> value) {
        this.subresources.longRunningThreads = value;
        return (T)this;
    }

    public T longRunningThreads(LongRunningThreads value) {
        this.subresources.longRunningThreads.add(value);
        return (T)this;
    }

    public T longRunningThreads(String childKey, LongRunningThreadsConsumer consumer) {
        LongRunningThreads child = new LongRunningThreads(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.longRunningThreads(child);
        return (T)this;
    }

    public T longRunningThreads(String childKey) {
        this.longRunningThreads(childKey, null);
        return (T)this;
    }

    public T longRunningThreads(LongRunningThreadsSupplier supplier) {
        this.longRunningThreads(supplier.get());
        return (T)this;
    }

    public T shortRunningThreads(List<ShortRunningThreads> value) {
        this.subresources.shortRunningThreads = value;
        return (T)this;
    }

    public T shortRunningThreads(ShortRunningThreads value) {
        this.subresources.shortRunningThreads.add(value);
        return (T)this;
    }

    public T shortRunningThreads(String childKey, ShortRunningThreadsConsumer consumer) {
        ShortRunningThreads child = new ShortRunningThreads(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.shortRunningThreads(child);
        return (T)this;
    }

    public T shortRunningThreads(String childKey) {
        this.shortRunningThreads(childKey, null);
        return (T)this;
    }

    public T shortRunningThreads(ShortRunningThreadsSupplier supplier) {
        this.shortRunningThreads(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="name")
    public String name() {
        return this.name;
    }

    public T name(String value) {
        String oldValue = this.name;
        this.name = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("name", oldValue, value);
        }
        return (T)this;
    }

    public static class WorkmanagerResources {
        private List<LongRunningThreads> longRunningThreads = new ArrayList<LongRunningThreads>();
        private List<ShortRunningThreads> shortRunningThreads = new ArrayList<ShortRunningThreads>();

        @Subresource
        public List<LongRunningThreads> longRunningThreads() {
            return this.longRunningThreads;
        }

        public LongRunningThreads longRunningThreads(String key) {
            return this.longRunningThreads.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ShortRunningThreads> shortRunningThreads() {
            return this.shortRunningThreads;
        }

        public ShortRunningThreads shortRunningThreads(String key) {
            return this.shortRunningThreads.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

