package org.wildfly.swarm.config;

import org.wildfly.swarm.config.ResourceAdapters;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ResourceAdaptersConsumer<T extends ResourceAdapters<T>> {

	/**
	 * Configure a pre-constructed instance of ResourceAdapters resource
	 * 
	 * @parameter Instance of ResourceAdapters to configure
	 * @return nothing
	 */
	void accept(T value);

	default ResourceAdaptersConsumer<T> andThen(
			ResourceAdaptersConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}