package org.wildfly.swarm.config.datasources.xa_data_source;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * List of xa-datasource-property
 */
@Address("/subsystem=datasources/xa-data-source=*/xa-datasource-properties=*")
@ResourceType("xa-datasource-properties")
public class XADatasourceProperties<T extends XADatasourceProperties<T>>
		extends
			HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private String value;

	public XADatasourceProperties(String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Specifies a property value to assign to the XADataSource implementation
	 * class. Each property is identified by the name attribute and the property
	 * value is given by the xa-datasource-property element content. The
	 * property is mapped onto the XADataSource implementation by looking for a
	 * JavaBeans style getter method for the property name. If found, the value
	 * of the property is set using the JavaBeans setter with the element text
	 * translated to the true property type using the java.beans.PropertyEditor
	 */
	@ModelNodeBinding(detypedName = "value")
	public String value() {
		return this.value;
	}

	/**
	 * Specifies a property value to assign to the XADataSource implementation
	 * class. Each property is identified by the name attribute and the property
	 * value is given by the xa-datasource-property element content. The
	 * property is mapped onto the XADataSource implementation by looking for a
	 * JavaBeans style getter method for the property name. If found, the value
	 * of the property is set using the JavaBeans setter with the element text
	 * translated to the true property type using the java.beans.PropertyEditor
	 */
	@SuppressWarnings("unchecked")
	public T value(String value) {
		Object oldValue = this.value;
		this.value = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("value", oldValue, value);
		return (T) this;
	}
}