package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A file system based passivation store
 */
@Address("/subsystem=ejb3/file-passivation-store=*")
@ResourceType("file-passivation-store")
public class FilePassivationStore<T extends FilePassivationStore<T>>
		extends
			HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private Long idleTimeout;
	private Integer maxSize;

	public FilePassivationStore(String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The timeout in units specified by idle-timeout-unit, after which a bean
	 * will passivate
	 */
	@ModelNodeBinding(detypedName = "idle-timeout")
	public Long idleTimeout() {
		return this.idleTimeout;
	}

	/**
	 * The timeout in units specified by idle-timeout-unit, after which a bean
	 * will passivate
	 */
	@SuppressWarnings("unchecked")
	public T idleTimeout(Long value) {
		Object oldValue = this.idleTimeout;
		this.idleTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("idleTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old
	 * beans to passivate
	 */
	@ModelNodeBinding(detypedName = "max-size")
	public Integer maxSize() {
		return this.maxSize;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old
	 * beans to passivate
	 */
	@SuppressWarnings("unchecked")
	public T maxSize(Integer value) {
		Object oldValue = this.maxSize;
		this.maxSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxSize", oldValue, value);
		return (T) this;
	}
}