package org.wildfly.swarm.config.infinispan;

import org.wildfly.swarm.config.infinispan.CacheContainer;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface CacheContainerConsumer<T extends CacheContainer<T>> {

	/**
	 * Configure a pre-constructed instance of CacheContainer resource
	 * 
	 * @parameter Instance of CacheContainer to configure
	 * @return nothing
	 */
	void accept(T value);

	default CacheContainerConsumer<T> andThen(CacheContainerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}