package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.CustomStore;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface CustomStoreConsumer<T extends CustomStore<T>> {

	/**
	 * Configure a pre-constructed instance of CustomStore resource
	 * 
	 * @parameter Instance of CustomStore to configure
	 * @return nothing
	 */
	void accept(T value);

	default CustomStoreConsumer<T> andThen(CustomStoreConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}