package org.wildfly.swarm.config.jmx;

import org.wildfly.swarm.config.jmx.ExpressionExposeModel;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ExpressionExposeModelConsumer<T extends ExpressionExposeModel<T>> {

	/**
	 * Configure a pre-constructed instance of ExpressionExposeModel resource
	 * 
	 * @parameter Instance of ExpressionExposeModel to configure
	 * @return nothing
	 */
	void accept(T value);

	default ExpressionExposeModelConsumer<T> andThen(
			ExpressionExposeModelConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}