package org.wildfly.swarm.config.jmx;

import org.wildfly.swarm.config.jmx.ResolvedExposeModel;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ResolvedExposeModelConsumer<T extends ResolvedExposeModel<T>> {

	/**
	 * Configure a pre-constructed instance of ResolvedExposeModel resource
	 * 
	 * @parameter Instance of ResolvedExposeModel to configure
	 * @return nothing
	 */
	void accept(T value);

	default ResolvedExposeModelConsumer<T> andThen(
			ResolvedExposeModelConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}