package org.wildfly.swarm.config.management.access.syslog_handler;

import org.wildfly.swarm.config.management.access.syslog_handler.TcpProtocol;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface TcpProtocolConsumer<T extends TcpProtocol<T>> {

	/**
	 * Configure a pre-constructed instance of TcpProtocol resource
	 * 
	 * @parameter Instance of TcpProtocol to configure
	 * @return nothing
	 */
	void accept(T value);

	default TcpProtocolConsumer<T> andThen(TcpProtocolConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}