package org.wildfly.swarm.config.management.security_realm.authorization;

import org.wildfly.swarm.config.management.security_realm.authorization.AdvancedFilterUsernameToDn;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface AdvancedFilterUsernameToDnConsumer<T extends AdvancedFilterUsernameToDn<T>> {

	/**
	 * Configure a pre-constructed instance of AdvancedFilterUsernameToDn
	 * resource
	 * 
	 * @parameter Instance of AdvancedFilterUsernameToDn to configure
	 * @return nothing
	 */
	void accept(T value);

	default AdvancedFilterUsernameToDnConsumer<T> andThen(
			AdvancedFilterUsernameToDnConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}