package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
/**
 * A broadcast group is the means by which a server broadcasts connectors over
 * the network.
 */
@Address("/subsystem=messaging-activemq/server=*/broadcast-group=*")
@ResourceType("broadcast-group")
public class BroadcastGroup<T extends BroadcastGroup<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private Long broadcastPeriod;
	private List<String> connectors;
	private String jgroupsChannel;
	private String jgroupsStack;
	private String socketBinding;
	private Boolean started;

	public BroadcastGroup(String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The period in milliseconds between consecutive broadcasts.
	 */
	@ModelNodeBinding(detypedName = "broadcast-period")
	public Long broadcastPeriod() {
		return this.broadcastPeriod;
	}

	/**
	 * The period in milliseconds between consecutive broadcasts.
	 */
	@SuppressWarnings("unchecked")
	public T broadcastPeriod(Long value) {
		Object oldValue = this.broadcastPeriod;
		this.broadcastPeriod = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("broadcastPeriod", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies the names of connectors that will be broadcast.
	 */
	@ModelNodeBinding(detypedName = "connectors")
	public List<String> connectors() {
		return this.connectors;
	}

	/**
	 * Specifies the names of connectors that will be broadcast.
	 */
	@SuppressWarnings("unchecked")
	public T connectors(List<String> value) {
		Object oldValue = this.connectors;
		this.connectors = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectors", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies the names of connectors that will be broadcast.
	 */
	@SuppressWarnings("unchecked")
	public T connector(String value) {
		if (this.connectors == null) {
			this.connectors = new java.util.ArrayList<>();
		}
		this.connectors.add(value);
		return (T) this;
	}

	/**
	 * Specifies the names of connectors that will be broadcast.
	 */
	@SuppressWarnings("unchecked")
	public T connectors(String... args) {
		connectors(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * The name used by a JGroups channel to join a cluster.
	 */
	@ModelNodeBinding(detypedName = "jgroups-channel")
	public String jgroupsChannel() {
		return this.jgroupsChannel;
	}

	/**
	 * The name used by a JGroups channel to join a cluster.
	 */
	@SuppressWarnings("unchecked")
	public T jgroupsChannel(String value) {
		Object oldValue = this.jgroupsChannel;
		this.jgroupsChannel = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jgroupsChannel", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of a stack defined in the org.jboss.as.clustering.jgroups
	 * subsystem that is used to form a cluster.
	 */
	@ModelNodeBinding(detypedName = "jgroups-stack")
	public String jgroupsStack() {
		return this.jgroupsStack;
	}

	/**
	 * The name of a stack defined in the org.jboss.as.clustering.jgroups
	 * subsystem that is used to form a cluster.
	 */
	@SuppressWarnings("unchecked")
	public T jgroupsStack(String value) {
		Object oldValue = this.jgroupsStack;
		this.jgroupsStack = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jgroupsStack", oldValue, value);
		return (T) this;
	}

	/**
	 * The broadcast group socket binding.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The broadcast group socket binding.
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(String value) {
		Object oldValue = this.socketBinding;
		this.socketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("socketBinding", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the broadcast group is started.
	 */
	@ModelNodeBinding(detypedName = "started")
	public Boolean started() {
		return this.started;
	}

	/**
	 * Whether the broadcast group is started.
	 */
	@SuppressWarnings("unchecked")
	public T started(Boolean value) {
		Object oldValue = this.started;
		this.started = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("started", oldValue, value);
		return (T) this;
	}
}